//Original Version of Xmas Tree program from year 1
// Includes functions & for loops

#include <iostream>			//for cin >> and cout <<
#include <cassert>			//for assert
#include <conio.h>			//for _kbhit
#include <windows.h>
#include "stdio.h"
using namespace std;

//declare constants: symbols used for the drawing
const char BLANK = ' ';
const char LEAF = '#';
const char WOOD = '|';
const char EOL = '\n';		//end of line symbol

//declare variables
int height;					//overall tree height
int branchLine;				//loop counter for each line of the foliage
int timedLoop;
long  counts;

#define million 1.0E6		// to get times in micro seconds
int iterations = 1000;		// execute the main drawing loop this number of times
float frequency;			// timing clock frequency
float elapsed_time;			// time for 1 iteration
float accumulated_elapsed_time;

int tree_sizes[] = {3,4,5,6,7,8,9,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80,85,90,95,100};
const char XT_times[] = "5005 SPAG Xmas Tree Times.txt";  // filename for the timing data output file

LARGE_INTEGER start, end, runtimestart, runtimeend, freq;;	// for timing

int main() 					//draw Xmas tree
{
	void getValidHeight();
	void drawBranches();
	void drawTrunk();

	getValidHeight();

	QueryPerformanceFrequency(&freq);
	QueryPerformanceCounter(&runtimestart);
	frequency = (float)freq.LowPart;
	ofstream tree_times;
	tree_times.open (XT_times, ios::out);
	tree_times << "Height\t\tTotal\t\tAverage (all micro seconds) for "<< iterations << " iterations. Frequency= "<< frequency <<"\n";

	// ************** code to be timed ***********************************************
	
	height = tree_sizes[tree];
	accumulated_elapsed_time = 0.0;
	for (int i = 0; i <iterations; i++)
	{
			// ************** Set up timer ***************************************************
		QueryPerformanceCounter(&start);
		drawBranches();
		drawTrunk();
		/*QueryPerformanceCounter(&end);	
		frequency = (float)freq.LowPart;
		counts += (end.LowPart - start.LowPart);*/
		long counts = (end.LowPart - start.LowPart);
		elapsed_time = (float)counts/frequency;

		accumulated_elapsed_time += elapsed_time;
	}

	// ************** end of code to be timed ****************************************

	QueryPerformanceCounter(&runtimeend);
    long runtime = (runtimeend.LowPart - runtimestart.LowPart);
	elapsed_time = (float)runtime/frequency;
	tree_times << "\nOverall run time = " << elapsed_time << " seconds\n";
	tree_times.close();


	/*float elapsed_time = (float)counts/frequency;

	std::cout << "\nFrequency = " << frequency/million << " million counts/second\n";
	std::cout << "\nTotal time = " << ((elapsed_time * million) / 500) << " micro seconds\n" ;*/
	// *******************************************************************************


	//std::cout << "\nLast index value = " << index <<"\n";

	cout << "\n\nHit <enter> to finish";
	while ( !_kbhit());		//hold the screen until a key is pressed
	return( 0);
}

void getValidHeight()		//get valid height for the tree
{
	cout << "\nEnter the size of the tree (4-20): ";
	cin >> height;
	while ( ( height < 4) || ( height > 60))
	{
		cout << "\nERROR: Invalid height!";
		cout << "\nEnter height: ";
		cin >> height;
	}
}

void drawBranches()				//draw foliage
{
	assert( ( (height >= 4) && (height <= 60) ) );
	void drawABranch();
	for ( branchLine = 1; branchLine <= (height - 2); ++branchLine)
		drawABranch();			//draw one line of foliage
}

void drawABranch()				//draw one line of foliage
{
	assert( (height >= 4) && (height <= 60) && 
	        (branchLine >= 1) && (branchLine <= height - 2) );
	//draw the spaces
	for ( int spaces( 1); spaces <= ((height - 2) - branchLine); ++spaces)
		cout << BLANK;			//print a space

	//draw the leaves
	for ( int leaves( 1); leaves <= (branchLine * 2) - 1; ++leaves)
		cout << LEAF;			//print a leaf symbol
	cout << EOL;				//go to next line
}

void drawTrunk()				//draw trunk
{
	assert( (height >= 4) && (height <= 60) );
	for (int trunkLine( 1); trunkLine <= 2; ++trunkLine)
	{
		//draw the spaces
		for ( int spaces( 1); spaces <= (height - 3); ++spaces)
			cout << BLANK;		//print a space
		cout << WOOD;			//print a trunk symbol
		cout << EOL;			//go to next line
	}
}

